/*
 * Decompiled with CFR 0.152.
 */
package org.danbrough.xtras.sonatype;

import java.io.Closeable;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Base64;
import javax.xml.parsers.DocumentBuilderFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.danbrough.xtras.LoggingKt;
import org.danbrough.xtras.sonatype.PromoteRequestResponse;
import org.danbrough.xtras.sonatype.SonatypeExtension;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.LogLevel;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a0\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\u000b\u001a\u00020\f*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a8\u0006\u0010"}, d2={"parsePromoteRequest", "Lorg/danbrough/xtras/sonatype/PromoteRequestResponse;", "input", "Ljava/io/InputStream;", "sonatypeOpenRepository", "stagingProfileId", "", "description", "username", "password", "urlBase", "createOpenRepoTask", "", "Lorg/gradle/api/Project;", "extn", "Lorg/danbrough/xtras/sonatype/SonatypeExtension;", "plugin"})
public final class SonatypeOpenRepositoryKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final PromoteRequestResponse sonatypeOpenRepository(@NotNull String stagingProfileId, @NotNull String description, @NotNull String username, @NotNull String password, @NotNull String urlBase) {
        Intrinsics.checkNotNullParameter((Object)stagingProfileId, (String)"stagingProfileId");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)urlBase, (String)"urlBase");
        String url = urlBase + "/service/local/staging/profiles/" + stagingProfileId + "/start";
        URLConnection $this$sonatypeOpenRepository_u24lambda_u241 = new URL(url).openConnection();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$sonatypeOpenRepository_u24lambda_u241, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection cfr_ignored_0 = (HttpURLConnection)$this$sonatypeOpenRepository_u24lambda_u241;
        ((HttpURLConnection)$this$sonatypeOpenRepository_u24lambda_u241).setRequestMethod("POST");
        ((HttpURLConnection)$this$sonatypeOpenRepository_u24lambda_u241).setDoOutput(true);
        $this$sonatypeOpenRepository_u24lambda_u241.addRequestProperty("Content-Type", "application/xml");
        Base64.Encoder encoder = Base64.getEncoder();
        Object object = username + ":" + password;
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset()");
        byte[] byArray = ((String)object).getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        $this$sonatypeOpenRepository_u24lambda_u241.addRequestProperty("Authorization", "Basic: " + encoder.encodeToString(byArray));
        object = new PrintWriter(((HttpURLConnection)$this$sonatypeOpenRepository_u24lambda_u241).getOutputStream());
        Throwable throwable = null;
        try {
            PrintWriter output = (PrintWriter)object;
            boolean bl2 = false;
            output.write(StringsKt.trimIndent((String)("<promoteRequest>\n    <data>\n        <description>" + description + "</description>\n    </data>\n</promoteRequest>")));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        if (((HttpURLConnection)$this$sonatypeOpenRepository_u24lambda_u241).getResponseCode() == 201) {
            InputStream inputStream = ((HttpURLConnection)$this$sonatypeOpenRepository_u24lambda_u241).getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
            return SonatypeOpenRepositoryKt.parsePromoteRequest(inputStream);
        }
        throw new Error("Failed: error: " + ((HttpURLConnection)$this$sonatypeOpenRepository_u24lambda_u241).getResponseCode() + ": " + ((HttpURLConnection)$this$sonatypeOpenRepository_u24lambda_u241).getResponseCode() + ": " + ((HttpURLConnection)$this$sonatypeOpenRepository_u24lambda_u241).getResponseMessage());
    }

    @NotNull
    public static final PromoteRequestResponse parsePromoteRequest(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
        Node $this$parsePromoteRequest_u24lambda_u242 = doc.getElementsByTagName("data").item(0);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$parsePromoteRequest_u24lambda_u242, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
        Element cfr_ignored_0 = (Element)$this$parsePromoteRequest_u24lambda_u242;
        String repoID = ((Element)$this$parsePromoteRequest_u24lambda_u242).getElementsByTagName("stagedRepositoryId").item(0).getTextContent();
        String description = ((Element)$this$parsePromoteRequest_u24lambda_u242).getElementsByTagName("description").item(0).getTextContent();
        Intrinsics.checkNotNullExpressionValue((Object)repoID, (String)"repoID");
        Intrinsics.checkNotNullExpressionValue((Object)description, (String)"description");
        return new PromoteRequestResponse(repoID, description);
    }

    public static final void createOpenRepoTask(@NotNull Project $this$createOpenRepoTask, @NotNull SonatypeExtension extn) {
        Intrinsics.checkNotNullParameter((Object)$this$createOpenRepoTask, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)extn, (String)"extn");
        if ($this$createOpenRepoTask.getRootProject().getTasks().findByPath("sonatypeOpenRepository") != null) {
            return;
        }
        $this$createOpenRepoTask.getRootProject().getTasks().register("sonatypeOpenRepository", new Action(extn){
            final /* synthetic */ SonatypeExtension $extn;
            {
                this.$extn = $extn;
            }

            public final void execute(@NotNull Task $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.setDescription("      Open a new sonatype repository and prints it to stdout.\n      Specify the repository description with -Psonatype.description=\"..\".");
                $this$register.setGroup("xtras");
                $this$register.doLast(new Action(this.$extn){
                    final /* synthetic */ SonatypeExtension $extn;
                    {
                        this.$extn = $extn;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void execute(@NotNull Task $this$doLast) {
                        void $this$logDebug_u24default$iv;
                        Intrinsics.checkNotNullParameter((Object)$this$doLast, (String)"$this$doLast");
                        Object object = this.$extn.getProfileID().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extn.profileID.get()");
                        if (StringsKt.isBlank((CharSequence)((CharSequence)object))) {
                            throw new Error("sonatype.profileID not set");
                        }
                        Object object2 = this.$extn.getProfileID().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"extn.profileID.get()");
                        String string = (String)object2;
                        Object object3 = this.$extn.getDescription().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"extn.description.get()");
                        String string2 = (String)object3;
                        Object object4 = this.$extn.getUsername().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"extn.username.get()");
                        String string3 = (String)object4;
                        Object object5 = this.$extn.getPassword().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"extn.password.get()");
                        String string4 = (String)object5;
                        Object object6 = this.$extn.getUrlBase().get();
                        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"extn.urlBase.get()");
                        PromoteRequestResponse response = SonatypeOpenRepositoryKt.sonatypeOpenRepository(string, string2, string3, string4, (String)object6);
                        Project project = $this$doLast.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                        Project project2 = project;
                        String msg$iv = "Received response: " + response;
                        Throwable err$iv = null;
                        boolean $i$f$logDebug = false;
                        LoggingKt.log((Project)$this$logDebug_u24default$iv, msg$iv, LogLevel.INFO, err$iv);
                        System.out.println((Object)("export sonatype.repoID=" + response.getRepositoryId()));
                    }
                });
            }
        });
    }
}

