/*
 * Decompiled with CFR 0.152.
 */
package org.danbrough.xtras.tasks;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.danbrough.xtras.ExtensionsKt;
import org.danbrough.xtras.LoggingKt;
import org.danbrough.xtras.XtrasDSL;
import org.danbrough.xtras.XtrasLibrary;
import org.danbrough.xtras.tasks.GitSourceConfig;
import org.danbrough.xtras.tasks.SourceTaskName;
import org.danbrough.xtras.tasks.TaskName;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Exec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.target.KonanTarget;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"gitSource", "", "Lorg/danbrough/xtras/XtrasLibrary;", "url", "", "commit", "registerDownloadTask", "registerGitSourceTasks", "registerGitTagsTask", "registerSourceExtractTask", "target", "Lorg/jetbrains/kotlin/konan/target/KonanTarget;", "plugin"})
@SourceDebugExtension(value={"SMAP\nsources.git.kt\nKotlin\n*S Kotlin\n*F\n+ 1 sources.git.kt\norg/danbrough/xtras/tasks/Sources_gitKt\n+ 2 logging.kt\norg/danbrough/xtras/LoggingKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 TaskContainerExtensions.kt\norg/gradle/kotlin/dsl/TaskContainerExtensionsKt\n*L\n1#1,177:1\n72#2:178\n1855#3,2:179\n263#4:181\n263#4:182\n*S KotlinDebug\n*F\n+ 1 sources.git.kt\norg/danbrough/xtras/tasks/Sources_gitKt\n*L\n28#1:178\n31#1:179,2\n109#1:181\n140#1:182\n*E\n"})
public final class Sources_gitKt {
    @XtrasDSL
    public static final void gitSource(@NotNull XtrasLibrary $this$gitSource, @NotNull String url, @NotNull String commit) {
        Intrinsics.checkNotNullParameter((Object)$this$gitSource, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        $this$gitSource.setSourceConfig$plugin(new GitSourceConfig(url, commit));
    }

    /*
     * WARNING - void declaration
     */
    public static final void registerGitSourceTasks(@NotNull XtrasLibrary $this$registerGitSourceTasks) {
        void $this$logInfo_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)$this$registerGitSourceTasks, (String)"<this>");
        Project project = $this$registerGitSourceTasks.getProject();
        String msg$iv = $this$registerGitSourceTasks.getName() + "::registerGitSourceTasks()";
        Throwable err$iv = null;
        boolean $i$f$logInfo = false;
        LoggingKt.log((Project)$this$logInfo_u24default$iv, msg$iv, LogLevel.WARN, err$iv);
        Sources_gitKt.registerGitTagsTask($this$registerGitSourceTasks);
        Sources_gitKt.registerDownloadTask($this$registerGitSourceTasks);
        Object object = $this$registerGitSourceTasks.getXtras().getNativeTargets().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"xtras.nativeTargets.get()");
        Iterable $this$forEach$iv = (Iterable)object;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KonanTarget it = (KonanTarget)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Sources_gitKt.registerSourceExtractTask($this$registerGitSourceTasks, it);
        }
    }

    private static final void registerDownloadTask(XtrasLibrary $this$registerDownloadTask) {
        XtrasLibrary.SourceConfig sourceConfig = $this$registerDownloadTask.getSourceConfig$plugin();
        Intrinsics.checkNotNull((Object)sourceConfig, (String)"null cannot be cast to non-null type org.danbrough.xtras.tasks.GitSourceConfig");
        GitSourceConfig config = (GitSourceConfig)sourceConfig;
        String downloadTaskName = TaskName.taskName$default(SourceTaskName.DOWNLOAD, $this$registerDownloadTask, null, 2, null);
        File repoDir = $this$registerDownloadTask.getDownloadsDir();
        File commitFile = FilesKt.resolve((File)repoDir, (String)(".commit_" + config.getCommit()));
        Project $this$registerDownloadTask_u24lambda_u241 = $this$registerDownloadTask.getProject();
        boolean bl = false;
        $this$registerDownloadTask_u24lambda_u241.getTasks().register(downloadTaskName, new Action($this$registerDownloadTask, config, commitFile, repoDir, $this$registerDownloadTask_u24lambda_u241){
            final /* synthetic */ XtrasLibrary $this_registerDownloadTask;
            final /* synthetic */ GitSourceConfig $config;
            final /* synthetic */ File $commitFile;
            final /* synthetic */ File $repoDir;
            final /* synthetic */ Project $this_run;
            {
                this.$this_registerDownloadTask = $receiver;
                this.$config = $config;
                this.$commitFile = $commitFile;
                this.$repoDir = $repoDir;
                this.$this_run = $receiver2;
            }

            public final void execute(@NotNull Task $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.setEnabled(this.$this_registerDownloadTask.getBuildEnabled() || $this$register.getProject().hasProperty("forceBuild"));
                $this$register.setGroup("xtras");
                $this$register.setDescription("Downloads the source code from the remote repository " + this.$config.getUrl() + " with commit: " + this.$config.getCommit());
                XtrasLibrary.SourceConfig sourceConfig = this.$this_registerDownloadTask.getSourceConfig$plugin();
                $this$register.getInputs().property("commit", (Object)(sourceConfig != null ? sourceConfig.hashCode() : 0));
                $this$register.getOutputs().file((Object)this.$commitFile);
                $this$register.doFirst(new Action(this.$this_run, this.$repoDir){
                    final /* synthetic */ Project $this_run;
                    final /* synthetic */ File $repoDir;
                    {
                        this.$this_run = $receiver;
                        this.$repoDir = $repoDir;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void execute(@NotNull Task $this$doFirst) {
                        void $this$logTrace_u24default$iv;
                        Intrinsics.checkNotNullParameter((Object)$this$doFirst, (String)"$this$doFirst");
                        Project project = this.$this_run;
                        String msg$iv = "running " + $this$doFirst.getName() + " repoDir: " + this.$repoDir + " exists: " + this.$repoDir.exists();
                        Throwable err$iv = null;
                        boolean $i$f$logTrace = false;
                        LoggingKt.log((Project)$this$logTrace_u24default$iv, msg$iv, LogLevel.DEBUG, err$iv);
                    }
                });
                if (!FilesKt.resolve((File)this.$repoDir, (String)"HEAD").exists()) {
                    $this$register.getActions().add(new Action(this.$this_run, this.$this_registerDownloadTask, this.$repoDir, this.$config){
                        final /* synthetic */ Project $this_run;
                        final /* synthetic */ XtrasLibrary $this_registerDownloadTask;
                        final /* synthetic */ File $repoDir;
                        final /* synthetic */ GitSourceConfig $config;
                        {
                            this.$this_run = $receiver;
                            this.$this_registerDownloadTask = $receiver2;
                            this.$repoDir = $repoDir;
                            this.$config = $config;
                        }

                        public final void execute(@NotNull Task $this$add) {
                            Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                            this.$this_run.exec(new Action(this.$this_registerDownloadTask, this.$this_run, $this$add, this.$repoDir){
                                final /* synthetic */ XtrasLibrary $this_registerDownloadTask;
                                final /* synthetic */ Project $this_run;
                                final /* synthetic */ Task $this_add;
                                final /* synthetic */ File $repoDir;
                                {
                                    this.$this_registerDownloadTask = $receiver;
                                    this.$this_run = $receiver2;
                                    this.$this_add = $this_add;
                                    this.$repoDir = $repoDir;
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final void execute(@NotNull ExecSpec $this$exec) {
                                    void $this$logTrace_u24default$iv;
                                    Project $this$logError_u24default$iv;
                                    Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                                    $this$exec.environment(XtrasLibrary.loadEnvironment$default(this.$this_registerDownloadTask, null, null, 3, null));
                                    Project project = this.$this_run;
                                    String msg$iv = "environment: " + $this$exec.getEnvironment();
                                    Throwable err$iv = null;
                                    boolean $i$f$logError = false;
                                    LoggingKt.log($this$logError_u24default$iv, msg$iv, LogLevel.ERROR, err$iv);
                                    $this$logError_u24default$iv = new Object[3];
                                    $this$logError_u24default$iv[0] = this.$this_registerDownloadTask.getXtras().getSh();
                                    $this$logError_u24default$iv[1] = "-c";
                                    Project project2 = this.$this_add.getProject();
                                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                                    $this$logError_u24default$iv[2] = "git init --bare " + ExtensionsKt.unixPath(project2, this.$repoDir);
                                    $this$exec.commandLine((Object[])$this$logError_u24default$iv);
                                    $this$logError_u24default$iv = this.$this_run;
                                    List list = $this$exec.getCommandLine();
                                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"commandLine");
                                    msg$iv = "running " + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                                    err$iv = null;
                                    boolean $i$f$logTrace = false;
                                    LoggingKt.log((Project)$this$logTrace_u24default$iv, msg$iv, LogLevel.DEBUG, err$iv);
                                }
                            });
                            this.$this_run.exec(new Action(this.$repoDir, this.$this_registerDownloadTask, this.$config, this.$this_run){
                                final /* synthetic */ File $repoDir;
                                final /* synthetic */ XtrasLibrary $this_registerDownloadTask;
                                final /* synthetic */ GitSourceConfig $config;
                                final /* synthetic */ Project $this_run;
                                {
                                    this.$repoDir = $repoDir;
                                    this.$this_registerDownloadTask = $receiver;
                                    this.$config = $config;
                                    this.$this_run = $receiver2;
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final void execute(@NotNull ExecSpec $this$exec) {
                                    void $this$logTrace_u24default$iv;
                                    Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                                    $this$exec.workingDir((Object)this.$repoDir);
                                    $this$exec.environment(XtrasLibrary.loadEnvironment$default(this.$this_registerDownloadTask, null, null, 3, null));
                                    Object[] objectArray = new Object[]{this.$this_registerDownloadTask.getXtras().getSh(), "-c", "git remote add origin  " + this.$config.getUrl()};
                                    $this$exec.commandLine(objectArray);
                                    objectArray = this.$this_run;
                                    List list = $this$exec.getCommandLine();
                                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"commandLine");
                                    String msg$iv = "running " + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                                    Throwable err$iv = null;
                                    boolean $i$f$logTrace = false;
                                    LoggingKt.log((Project)$this$logTrace_u24default$iv, msg$iv, LogLevel.DEBUG, err$iv);
                                }
                            });
                        }
                    });
                }
                $this$register.getActions().add(new Action(this.$this_run, this.$repoDir, this.$this_registerDownloadTask, this.$config, this.$commitFile){
                    final /* synthetic */ Project $this_run;
                    final /* synthetic */ File $repoDir;
                    final /* synthetic */ XtrasLibrary $this_registerDownloadTask;
                    final /* synthetic */ GitSourceConfig $config;
                    final /* synthetic */ File $commitFile;
                    {
                        this.$this_run = $receiver;
                        this.$repoDir = $repoDir;
                        this.$this_registerDownloadTask = $receiver2;
                        this.$config = $config;
                        this.$commitFile = $commitFile;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    public final void execute(@NotNull Task $this$add) {
                        Intrinsics.checkNotNullParameter((Object)$this$add, (String)"$this$add");
                        this.$this_run.exec(new Action(this.$repoDir, this.$this_registerDownloadTask, this.$config, this.$this_run){
                            final /* synthetic */ File $repoDir;
                            final /* synthetic */ XtrasLibrary $this_registerDownloadTask;
                            final /* synthetic */ GitSourceConfig $config;
                            final /* synthetic */ Project $this_run;
                            {
                                this.$repoDir = $repoDir;
                                this.$this_registerDownloadTask = $receiver;
                                this.$config = $config;
                                this.$this_run = $receiver2;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void execute(@NotNull ExecSpec $this$exec) {
                                void $this$logTrace_u24default$iv;
                                Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                                $this$exec.workingDir((Object)this.$repoDir);
                                $this$exec.environment(XtrasLibrary.loadEnvironment$default(this.$this_registerDownloadTask, null, null, 3, null));
                                Object[] objectArray = new Object[]{this.$this_registerDownloadTask.getXtras().getSh(), "-c", "git fetch --depth 1 origin " + this.$config.getCommit()};
                                $this$exec.commandLine(objectArray);
                                objectArray = this.$this_run;
                                List list = $this$exec.getCommandLine();
                                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"commandLine");
                                String msg$iv = "running: " + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                                Throwable err$iv = null;
                                boolean $i$f$logTrace = false;
                                LoggingKt.log((Project)$this$logTrace_u24default$iv, msg$iv, LogLevel.DEBUG, err$iv);
                            }
                        });
                        Object object = FilesKt.resolve((File)this.$repoDir, (String)"FETCH_HEAD");
                        Charset charset = Charsets.UTF_8;
                        int n = 8192;
                        Object object2 = object;
                        object2 = new InputStreamReader((InputStream)new FileInputStream((File)object2), charset);
                        object = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                        charset = this.$this_run;
                        File file = this.$commitFile;
                        object2 = null;
                        try {
                            void $this$logDebug_u24default$iv;
                            BufferedReader it = (BufferedReader)object;
                            boolean bl = false;
                            String string = it.readLine();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.readLine()");
                            Object object3 = string;
                            Object object4 = new Regex("\\s+");
                            int n2 = 2;
                            String commit = (String)CollectionsKt.first((List)object4.split((CharSequence)object3, n2));
                            object3 = charset;
                            String msg$iv = "writing " + commit + " to " + file.getAbsolutePath();
                            Throwable err$iv = null;
                            boolean $i$f$logDebug = false;
                            LoggingKt.log((Project)$this$logDebug_u24default$iv, msg$iv, LogLevel.INFO, err$iv);
                            object3 = file;
                            object4 = Charsets.UTF_8;
                            object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object4);
                            object4 = null;
                            try {
                                OutputStreamWriter writer = (OutputStreamWriter)object3;
                                boolean bl2 = false;
                                writer.write(commit);
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable) {
                                object4 = throwable;
                                throw throwable;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object3, (Throwable)object4);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable) {
                            object2 = throwable;
                            throw throwable;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                        }
                        this.$this_run.exec(new Action(this.$repoDir, this.$this_registerDownloadTask, this.$commitFile, this.$this_run){
                            final /* synthetic */ File $repoDir;
                            final /* synthetic */ XtrasLibrary $this_registerDownloadTask;
                            final /* synthetic */ File $commitFile;
                            final /* synthetic */ Project $this_run;
                            {
                                this.$repoDir = $repoDir;
                                this.$this_registerDownloadTask = $receiver;
                                this.$commitFile = $commitFile;
                                this.$this_run = $receiver2;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final void execute(@NotNull ExecSpec $this$exec) {
                                void $this$logTrace_u24default$iv;
                                Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
                                $this$exec.workingDir((Object)this.$repoDir);
                                $this$exec.environment(XtrasLibrary.loadEnvironment$default(this.$this_registerDownloadTask, null, null, 3, null));
                                String commit = FilesKt.readText$default((File)this.$commitFile, null, (int)1, null);
                                Object[] objectArray = new Object[]{this.$this_registerDownloadTask.getXtras().getSh(), "-c", "git reset --soft " + commit};
                                $this$exec.commandLine(objectArray);
                                objectArray = this.$this_run;
                                List list = $this$exec.getCommandLine();
                                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"commandLine");
                                String msg$iv = "running: " + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
                                Throwable err$iv = null;
                                boolean $i$f$logTrace = false;
                                LoggingKt.log((Project)$this$logTrace_u24default$iv, msg$iv, LogLevel.DEBUG, err$iv);
                            }
                        });
                    }
                });
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final void registerSourceExtractTask(XtrasLibrary $this$registerSourceExtractTask, KonanTarget target) {
        void $this$register$iv;
        String taskName = SourceTaskName.EXTRACT.taskName($this$registerSourceExtractTask, target);
        File srcDir = (File)$this$registerSourceExtractTask.getSourceDir().invoke((Object)target);
        TaskContainer taskContainer = $this$registerSourceExtractTask.getProject().getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
        TaskContainer taskContainer2 = taskContainer;
        Function1 configuration$iv = (Function1)new Function1<Exec, Unit>($this$registerSourceExtractTask, srcDir, target, taskName){
            final /* synthetic */ XtrasLibrary $this_registerSourceExtractTask;
            final /* synthetic */ File $srcDir;
            final /* synthetic */ KonanTarget $target;
            final /* synthetic */ String $taskName;
            {
                this.$this_registerSourceExtractTask = $receiver;
                this.$srcDir = $srcDir;
                this.$target = $target;
                this.$taskName = $taskName;
                super(1);
            }

            public final void invoke(@NotNull Exec $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.setGroup("xtras");
                $this$register.setEnabled(this.$this_registerSourceExtractTask.getBuildEnabled() || $this$register.getProject().hasProperty("forceBuild"));
                $this$register.setDescription("Extracts the source code for " + this.$this_registerSourceExtractTask.getName() + " to " + this.$srcDir);
                XtrasLibrary.SourceConfig sourceConfig = this.$this_registerSourceExtractTask.getSourceConfig$plugin();
                $this$register.getInputs().property("commit", (Object)(sourceConfig != null ? sourceConfig.hashCode() : 0));
                XtrasLibrary.SourceConfig sourceConfig2 = this.$this_registerSourceExtractTask.getSourceConfig$plugin();
                File commitFile = FilesKt.resolve((File)this.$srcDir, (String)(".commit_" + (sourceConfig2 != null ? sourceConfig2.hashCode() : 0)));
                $this$register.getOutputs().file((Object)commitFile);
                $this$register.onlyIf(new Spec(this.$this_registerSourceExtractTask, this.$target, $this$register){
                    final /* synthetic */ XtrasLibrary $this_registerSourceExtractTask;
                    final /* synthetic */ KonanTarget $target;
                    final /* synthetic */ Exec $this_register;
                    {
                        this.$this_registerSourceExtractTask = $receiver;
                        this.$target = $target;
                        this.$this_register = $this_register;
                    }

                    public final boolean isSatisfiedBy(Task it) {
                        return !((File)this.$this_registerSourceExtractTask.getPackageFile().invoke((Object)this.$target)).exists() || this.$this_register.getProject().hasProperty("forceBuild");
                    }
                });
                Object[] objectArray = new Object[]{TaskName.taskName$default(SourceTaskName.DOWNLOAD, this.$this_registerSourceExtractTask, null, 2, null)};
                $this$register.dependsOn(objectArray);
                $this$register.doFirst(new Action(this.$srcDir, this.$taskName, this.$this_registerSourceExtractTask){
                    final /* synthetic */ File $srcDir;
                    final /* synthetic */ String $taskName;
                    final /* synthetic */ XtrasLibrary $this_registerSourceExtractTask;
                    {
                        this.$srcDir = $srcDir;
                        this.$taskName = $taskName;
                        this.$this_registerSourceExtractTask = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void execute(@NotNull Task $this$doFirst) {
                        void $this$logDebug_u24default$iv;
                        Intrinsics.checkNotNullParameter((Object)$this$doFirst, (String)"$this$doFirst");
                        if (this.$srcDir.exists()) {
                            FilesKt.deleteRecursively((File)this.$srcDir);
                        }
                        Project project = $this$doFirst.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                        Project project2 = project;
                        String msg$iv = this.$taskName + ": cloning " + this.$this_registerSourceExtractTask.getSourceConfig$plugin() + " to " + this.$srcDir;
                        Throwable err$iv = null;
                        boolean $i$f$logDebug = false;
                        LoggingKt.log((Project)$this$logDebug_u24default$iv, msg$iv, LogLevel.INFO, err$iv);
                    }
                });
                $this$register.environment(XtrasLibrary.loadEnvironment$default(this.$this_registerSourceExtractTask, null, null, 3, null));
                objectArray = new Object[3];
                objectArray[0] = this.$this_registerSourceExtractTask.getXtras().getSh();
                objectArray[1] = "-c";
                Project project = $this$register.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                String string = ExtensionsKt.unixPath(project, this.$this_registerSourceExtractTask.getDownloadsDir());
                Project project2 = $this$register.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
                objectArray[2] = "git clone  " + string + " " + ExtensionsKt.unixPath(project2, this.$srcDir);
                $this$register.commandLine(objectArray);
                $this$register.doLast(new Action(commitFile){
                    final /* synthetic */ File $commitFile;
                    {
                        this.$commitFile = $commitFile;
                    }

                    public final void execute(@NotNull Task $this$doLast) {
                        Intrinsics.checkNotNullParameter((Object)$this$doLast, (String)"$this$doLast");
                        this.$commitFile.createNewFile();
                    }
                });
            }
        };
        boolean $i$f$register = false;
        Intrinsics.checkNotNullExpressionValue((Object)$this$register$iv.register(taskName, Exec.class, new Action(configuration$iv){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void execute(Object p0) {
                this.function.invoke(p0);
            }
        }), (String)"register(name, T::class.java, configuration)");
    }

    /*
     * WARNING - void declaration
     */
    private static final void registerGitTagsTask(XtrasLibrary $this$registerGitTagsTask) {
        Task task;
        XtrasLibrary.SourceConfig sourceConfig = $this$registerGitTagsTask.getSourceConfig$plugin();
        Intrinsics.checkNotNull((Object)sourceConfig, (String)"null cannot be cast to non-null type org.danbrough.xtras.tasks.GitSourceConfig");
        GitSourceConfig config = (GitSourceConfig)sourceConfig;
        String tagsTaskName = TaskName.taskName$default(SourceTaskName.TAGS, $this$registerGitTagsTask, null, 2, null);
        Task task2 = (Task)$this$registerGitTagsTask.getProject().getTasks().findByName(tagsTaskName);
        if (task2 == null) {
            void $this$register$iv;
            TaskContainer taskContainer = $this$registerGitTagsTask.getProject().getTasks();
            Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"project.tasks");
            TaskContainer taskContainer2 = taskContainer;
            Function1 configuration$iv = (Function1)new Function1<Exec, Unit>($this$registerGitTagsTask, config){
                final /* synthetic */ XtrasLibrary $this_registerGitTagsTask;
                final /* synthetic */ GitSourceConfig $config;
                {
                    this.$this_registerGitTagsTask = $receiver;
                    this.$config = $config;
                    super(1);
                }

                public final void invoke(@NotNull Exec $this$register) {
                    Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                    $this$register.setGroup("xtras");
                    $this$register.setDescription("Prints out the tags from the remote repository");
                    $this$register.environment(XtrasLibrary.loadEnvironment$default(this.$this_registerGitTagsTask, null, null, 3, null));
                    Object[] objectArray = new Object[]{this.$this_registerGitTagsTask.getXtras().getSh(), "-c", "git ls-remote -q --refs -t " + this.$config.getUrl()};
                    $this$register.commandLine(objectArray);
                    ByteArrayOutputStream stdout = new ByteArrayOutputStream();
                    $this$register.setStandardOutput((OutputStream)stdout);
                    $this$register.doLast(new Action(stdout){
                        final /* synthetic */ ByteArrayOutputStream $stdout;
                        {
                            this.$stdout = $stdout;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * WARNING - void declaration
                         */
                        public final void execute(@NotNull Task $this$doLast) {
                            Intrinsics.checkNotNullParameter((Object)$this$doLast, (String)"$this$doLast");
                            Closeable closeable = new InputStreamReader(new ByteArrayInputStream(this.$stdout.toByteArray()));
                            Throwable throwable = null;
                            try {
                                void $this$forEach$iv;
                                Iterable $this$sortedBy$iv;
                                void $this$mapTo$iv$iv;
                                InputStreamReader reader = (InputStreamReader)closeable;
                                boolean bl = false;
                                Iterable $this$map$iv = TextStreamsKt.readLines((Reader)reader);
                                boolean $i$f$map = false;
                                Iterable iterable = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void it;
                                    String string = (String)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl2 = false;
                                    CharSequence charSequence = (CharSequence)it;
                                    Regex regex = new Regex("\\s+");
                                    int n = 0;
                                    List it2 = regex.split(charSequence, n);
                                    boolean bl3 = false;
                                    collection.add(new Pair((Object)StringsKt.substringAfter$default((String)((String)it2.get(1)), (String)"refs/tags/", null, (int)2, null), it2.get(0)));
                                }
                                $this$map$iv = (List)destination$iv$iv;
                                boolean $i$f$sortedBy = false;
                                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                                    public final int compare(T a, T b) {
                                        Pair it = (Pair)a;
                                        boolean bl = false;
                                        Comparable comparable = (Comparable)((Object)((String)it.getFirst()));
                                        it = (Pair)b;
                                        Comparable comparable2 = comparable;
                                        bl = false;
                                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getFirst()))));
                                    }
                                });
                                boolean $i$f$forEach = false;
                                for (E element$iv : $this$forEach$iv) {
                                    Pair it = (Pair)element$iv;
                                    boolean bl4 = false;
                                    System.out.println((Object)("TAG: " + it.getFirst() + "\t" + it.getSecond()));
                                }
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                        }
                    });
                }
            };
            boolean $i$f$register = false;
            TaskProvider taskProvider = $this$register$iv.register(tagsTaskName, Exec.class, new /* invalid duplicate definition of identical inner class */);
            task = taskProvider;
            Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"register(name, T::class.java, configuration)");
        } else {
            task = task2;
        }
    }
}

